<?php
/**
 * Setup Wiki Tags
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap = nisje_get_setting( 'capability_key', 'wiki' );

$args = apply_filters( 'nisje_wiki_tag_args', [
	'labels'                => [
		'name'              => esc_html_x( 'Tags', 'taxonomy general name', 'nisje-wiki' ),
		'singular_name'     => esc_html_x( 'Tags', 'taxonomy singular name', 'nisje-wiki' ),
		'search_items'      => esc_html__( 'Search tags', 'nisje-wiki' ),
		'all_items'         => esc_html__( 'All tags', 'nisje-wiki' ),
		'parent_item'       => esc_html__( 'Parent', 'nisje-wiki' ),
		'parent_item_colon' => esc_html__( 'Parent:', 'nisje-wiki' ),
		'edit_item'         => esc_html__( 'Edit', 'nisje-wiki' ),
		'update_item'       => esc_html__( 'Update', 'nisje-wiki' ),
		'add_new_item'      => esc_html__( 'Add New Tag', 'nisje-wiki' ),
		'new_item_name'     => esc_html__( 'New Tag Name', 'nisje-wiki' ),
		'menu_name'         => esc_html__( 'Tags', 'nisje-wiki' ),
	],
	'hierarchical'          => false,
	'show_admin_column'     => true,
	'show_ui'               => true,
	'query_var'             => true,
	'rewrite'               => false,
	'capability_type'       => $cap,
	'capabilities'          => [],
	'show_in_rest'          => true,
	'rest_base'             => 'dekode-wiki-tag',
	'rest_controller_class' => 'WP_REST_Terms_Controller',
] );

$object_type = apply_filters( 'nisje_wiki_tag_object_types', [ nisje_get_setting( 'post_type_name', 'wiki' ) ] );

register_taxonomy( 'dekode-wiki-tag', $object_type, $args );
