<?php
/**
 * The main header template file
 *
 * @package Nisje
 */

declare( strict_types=1 );

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Silence is golden.' );
}

$body_classes = apply_filters( 'nisje_body_class', 'nisje-body' );

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
		<?php wp_head(); ?>
	</head>
	<body class="<?php echo esc_attr( $body_classes ); ?>">
		<a href="#main-content" class="skip-link components-visually-hidden">
			<?php esc_html_e( 'Skip to content', 'nisje-theme' ); ?>
		</a>
